{$A+,B+,D+,E+,F+,G+,I+,L+,N+,O+,P-,Q+,R+,S+,T-,V+,X+,Y+}
(*  Unit  BAR25
    Author  Hannes Streicher
    Email   HStreicher@T-Online.de
            Compuserve 101447;227
    Address Tannenstr. 3
            D-82049 Pullach
            Germany
    Shareware DM 10.--
    Kostenlos fr Private Anwender und Lehrzwecke
    Free for private use and teaching purposes.
    Stand          1996.12.21
*)

unit Bar25;

interface

uses Printer; (* Turbo Pascal Unit which opens LST device for output *)

type BarType = array[1..1000] of Byte;

var  BarLength : Integer;
     BarPtr    : ^BarType;

procedure Bar2of5(T : string);

procedure Bar3_9(T : string);

procedure Bar_Ean13(Eant : string);
(* Input EANT : EAN with length 12 , Checksum Digit is computed internally *)

function CheckSum(S : string): Char;

function Ean_CheckSum(T : string): Char;

procedure TestPrintEpson;  (* for epsons only *)
(* warning !!! on any printer with ribbons or ink jets where the dots come out *)
(* bigger then the spaces in a alternate pattern it is adviseable to make the *)
(* spaces bigger by one unit to compensate the blur (smudge, or whatever you want*)
(* to call it *)

procedure PrintBarHP(Scale , DPI, Height  : Integer);
(* print barcode horizontal on printers using PCL 4 and up
   such as HP Laserjets
  -Scale is the number of repeats each dot is repeated horizontally
  -DPI is the output resolution for the print 75 100 150 300
     must be allowed for the printer , no checking is performed here
  -Height is the number of lines repeated below oneanother
     again the height of a line is influenced by the DPI setting
   Setting Scale to 1 and DPI to 75 is equivalent to Scale =4 and DPI = 300 ,
   exept that it generates 4 times more data to be sent to the printer
   On a Laserprinter a setting of Scale = 1 and DPI = 75 gives good results
   Height = 30 is 1 CM high at 75 DPI *)


procedure DoInit;

implementation

const InitCalled : Boolean = False;

procedure Bar2of5(T : string); (* Code 2 of 5 Interleaved *)
const Bar25: array['0'..'9'] of string[5] =
     ('00110','10001','01001','11000','00101',
      '10100','01100','00011','10010','01010');
var I,J   : Integer;
    c1,c2 : Char;
begin
  if not InitCalled then DoInit;
  FillChar(BarPtr^,SizeOf(BarPtr^),0);
  BarLength:=0;
  (* check string *)
  if Odd(length(T)) then T:='0'+T;  (* interleaved thf only even length *)
  J:=0;
  for I:=1 to length(T) do if T[I]=' ' then T[I]:='0';
  for I:=1 to length(T) do if not(T[I] in ['0'..'9']) then inc(J);
  if J>0 then begin Write(^G); Exit ; end; (* illegal character *)
  (* start barcode *)
  BarPtr^[1]:=255;
  BarPtr^[3]:=255;
  BarLength:=4;
  for I:=0 to pred(length(T) div 2) do
    begin
      c1:=T[I*2+1];
      c2:=T[I*2+2];
      for J:=1 to 5 do
       begin
         inc(BarLength); BarPtr^[BarLength]:=255;
         if Bar25[c1][J]='1' then
           begin inc(BarLength); BarPtr^[BarLength]:=255; end;
         inc(BarLength);  (* blank *)
         if Bar25[c2][J]='1' then inc(BarLength);
       end; (* for j *)
    end; (* for i *)
  (* End Barcode *)
  inc(BarLength); BarPtr^[BarLength]:=255;
  inc(BarLength); BarPtr^[BarLength]:=255;
  inc(BarLength);
  inc(BarLength); BarPtr^[BarLength]:=255;
end;

procedure Bar3_9(T : string);
type  b39T   = array[1..44,1..2] of string[5];
const B39  : b39T =
    (('00110','01000'),('10001','01000'),('01001','01000'),('11000','01000'),
     ('00101','01000'),('10100','01000'),('01100','01000'),('00011','01000'),
     ('10010','01000'),('01010','01000'),('10001','00100'),('01001','00100'),
     ('11000','00100'),('00101','00100'),('10100','00100'),('01100','00100'),
     ('00011','00100'),('10010','00100'),('01010','00100'),('00110','00100'),
     ('10001','00010'),('01001','00010'),('11000','00010'),('00101','00010'),
     ('10100','00010'),('01100','00010'),('00011','00010'),('10010','00010'),
     ('01010','00010'),('00110','00010'),('10001','10000'),('01001','10000'),
     ('11000','10000'),('00101','10000'),('10100','10000'),('01100','10000'),
     ('00011','10000'),('10010','10000'),('01010','10000'),('00000','11100'),
     ('00000','11010'),('00000','10110'),('00000','01110'),('00110','10000'));

var  I,J,K : Integer;
     Len   : Integer;
     bl,C,ii,iii,
     Bit   : Integer;
begin
  if not InitCalled then DoInit;
  T:='*'+T+'*';
  for I:=1 to length(T) do T[I]:=UpCase(T[I]);
  Len:=length(T);
  BarLength:=0;
  FillChar(BarPtr^,SizeOf(BarPtr^),#0);
  (* check string *)
  J:=0;
  for I:=1 to length(T) do
    if Pos(T[I],'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*')=0 then inc(J);
  if J<>0 then begin Write(^G); Exit; end; (* illegal char *)
  for I:=1 to Len do
    begin
      K:=Pos(T[I],'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*');
      for J:=1 to 5 do
        begin
          C:=2;
          if B39[K,1][J]='1' then C:=4;
          for ii:=1 to C do
            begin
              inc(BarLength);
              BarPtr^[BarLength]:=255;
            end;(* FOR II / FOR III *)
          C:=2;
          if B39[K,2][J]='1' then C:=4;
          inc(BarLength,C);  (* add spaces *)
        end; (* J *)
    end; (* for i:=1 to len *)
end; (* bar code print *)

function Ean_CheckSum(T : string): Char;
var LFlag,RFlag : string[2];
    tmp,
    InData      : string[20];
    es,os       : Longint;
    I,J         : Integer;
begin
  LFlag:=T[1];
  RFlag:=T[2];
  InData:=Copy(T,3,10);  (* company (5) + prod code (5) *)
  (* compute checksum *)
  es:=0;  os:=0;
  for I:=1 to 5 do
    begin
      J:=Ord(InData[pred(I)*2+1])-Ord('0');
      es:=es+J;
      J:=Ord(InData[I*2])-Ord('0');
      os:=os+J;
    end;
  es:=es+Ord(LFlag[1])-Ord('0');
  os:=os+Ord(RFlag[1])-Ord('0');
  es:=os*3+es;
  es:=es - ( es  div 10)*10;  (* last digit only *)
  if es<>0 then es:=10-es;
  Str(es,tmp);
  Ean_CheckSum:=tmp[length(tmp)];
end;

procedure Bar_Ean13(Eant : string);
const EAN : array['0'..'9',1..2] of string[4] =  (* black,space *)
         (('3211','1123'),('2221','1222'),
          ('2122','2212'),('1411','1141'),
          ('1132','2311'),('1231','1321'),
          ('1114','4111'),('1312','2131'),
          ('1213','3121'),('3112','2113'));

     EANParity : array['0'..'9'] of string[6]=
          ('111000','110100','110010','110001','101100',
           '100110','100011','101010','101001','100101');

var LFlag,
    RFlag   : string[2];
    es,os   : Longint;
    T,
    tmp,
    InData  : string[20];
    ii,
    I,J,L   : Integer;
    ps      : Integer;
    ptn     : string[6];
    ch,ch1  : Char;
begin
  if not InitCalled then DoInit;
  T:=Copy(Eant,1,12);
  FillChar(BarPtr^,SizeOf(BarPtr^),0);
  BarLength:=0;
  (* check string *)
  if length(T)<>12 then Exit;  (* ean 13 , thf 12 + checksum *)
  J:=0;
  for I:=1 to length(T) do if T[I]=' ' then T[I]:='0';
  for I:=1 to length(T) do if not(T[I] in ['0'..'9']) then inc(J);
  if J>0 then begin Write(^G); Exit ; end; (* illegal character *)
  (* start barcode *)
  LFlag:=T[1];
  RFlag:=T[2];
  InData:=Copy(T,3,10);  (* company (5) + prod code (5) *)
  (* compute checksum *)
  es:=0;  os:=0;
  for I:=1 to 5 do
    begin
      J:=Ord(InData[pred(I)*2+1])-Ord('0');
      es:=es+J;
      J:=Ord(InData[I*2])-Ord('0');
      os:=os+J;
    end;
  es:=es+Ord(LFlag[1])-Ord('0');
  os:=os+Ord(RFlag[1])-Ord('0');
  es:=os*3+es;
  es:=es - ( es  div 10)*10;  (* last digit only *)
  if es<>0 then es:=10-es;
  Str(es,tmp);
  InData:=RFlag+InData+tmp[length(tmp)];  (* last digit of checksum *)
  ptn:=EANParity[LFlag[1]];
  if LFlag[1]='0' then ptn:='111111';
  (* start barcode *)
  inc(BarLength); BarPtr^[BarLength]:=255;
  inc(BarLength);
  inc(BarLength); BarPtr^[BarLength]:=255;
  for I:=1 to 6 do
    begin
      ch:=InData[I];
      for L:=1 to 2 do
        begin
          if ptn[I]='0' then
            begin
              ch1:=EAN[ch,2][pred(L)*2+1];
              J:=Ord(ch1)-Ord('0');
              inc(BarLength,J);  (* spaces *)
              ch1:=EAN[ch,2][L*2];
              J:=Ord(ch1)-Ord('0');
              for ii:=1 to J do
                begin
                  inc(BarLength);
                  BarPtr^[BarLength]:=255;
                end;
            end else begin
              ch1:=EAN[ch,1][pred(L)*2+1];
              J:=Ord(ch1)-Ord('0');
              inc(BarLength,J);  (* spaces *)
              ch1:=EAN[ch,1][L*2];
              J:=Ord(ch1)-Ord('0');
              for ii:=1 to J do
                begin
                  inc(BarLength);
                  BarPtr^[BarLength]:=255;
                end;
            end; (* if ptn[i] *)
        end;  (* for l *)
    end; (* for i *)
  inc(BarLength);
  inc(BarLength);  BarPtr^[BarLength]:=255;
  inc(BarLength);
  inc(BarLength);  BarPtr^[BarLength]:=255;
  inc(BarLength);
  for I:=7 to 12 do
    begin
      ch:=InData[I];
      for L:=1 to 2 do
        begin
          ch1:=EAN[ch,1][pred(L)*2+1];
          J:=Ord(ch1)-Ord('0');
          for ii:=1 to J do
            begin
              inc(BarLength);
              BarPtr^[BarLength]:=255;
            end;

          ch1:=EAN[ch,1][L*2];
          J:=Ord(ch1)-Ord('0');
          inc(BarLength,J);  (* spaces *)
        end;  (* for l *)
    end; (* for i *)
  inc(BarLength);  BarPtr^[BarLength]:=255;
  inc(BarLength);
  inc(BarLength);  BarPtr^[BarLength]:=255;
  Eant[13]:=InData[13];
end; (* bar ean13 *)

function CheckSum(S : string): Char;
var I,J : Longint;
begin
  J:=0;
  for I:=1 to length(S) do
    begin
      if S[I]=' ' then S[I]:='0';
      if Odd(I) then J:=J+(Ord(S[I])-Ord('0'))*4
                else J:=J+(Ord(S[I])-Ord('0'))*9;
    end;
  Str(J:0,S);
  CheckSum:=S[length(S)];
end;

procedure DoInit;
begin
  InitCalled:=True;
  New(BarPtr);
  FillChar(BarPtr^,SizeOf(BarPtr^),0);
  BarLength:=0;
end;

procedure TestPrintEpson;  (* for epsons only *)
var n1,n2,I,J,ii : Integer;
begin
  n1:=trunc(BarLength*3/256);
  n2:=BarLength*3 - n1*256;
  for I:=1 to 2 do
    begin
      Write(LST,chr(27),'Z',chr(n2),chr(n1));
      for ii:=1 to BarLength do
        for J:=1 to 3 do Write(LST,chr(BarPtr^[ii]));
      Writeln(LST);
    end;
end;

procedure PrintBarHP(Scale , DPI, Height  : Integer);
Const ESC = #27;
var Bl,ScCnt,ii,I,Bit : Integer;
    Bar               : array[1..100] of Byte;
begin
  FillChar(Bar,SizeOf(Bar),0);
  Bit:=0;
  bl:=1;
  for I:=1 to BarLength do
    begin
      for ScCnt :=1 to Scale do
        begin
          if BarPtr^[I]<>0 then Bar[bl]:=Bar[bl] or (128 shr Bit);
          inc(Bit);
          if Bit>7 then begin Bit:=0; inc(bl); end;
        end; (* for sccnt / to scale *)
    end; (* for i = 1 to barlength *)
  Write(LST,Esc,'*t',DPI:0,'R');  (* set dpi *)
  Write(LST,Esc,'*r1A');   (* start graphics at current position *)
  for I:=1 to 5 do Write(LST,Esc,'*b1W',chr(0));  (* 5 blank lines *)
  for I:=1 to Height do (* Height in Dots as set with DPI parameter  *)
    begin  (* zeilen drucken *)
      Write(LST,Esc,'*b',bl:0,'W');
      for ii:=1 to bl do Write(LST,chr(Bar[ii]));
    end; (* for i:=1 to 3 (= 2 zeilen ) *)
  Write(LST,Esc,'*rB'); (* end graphics *)
  (* write(lst, esc,'*rbC'); For PCL 3 Printers *)
end;

procedure Example;
var  Bar : string;
begin
  Bar:='401234512345';
  Bar_Ean13(Bar);
  PrintBarHP(1,75,30);
end;

end.


